// Blending consists of taking your normal RGB values and adding what is called A
// for Alpha. Our RGB function becomes RGBA where the Alpha value monitors
// the opacity of transparency of the current colour.

// Now to get this option into our OpenGL application we need to add the A value
// to our window. To do this just change the line:
// glutInitDisplayMode (GLUT_DOUBLE);
// to include "| GLUT_RGBA)" somewhere on the end.

// Now that our window supports Alpha values we want to be able to use the
// blending function built into OpenGL. To do this we enable the blending
// just like any other option with:
// glEnable glcBlend

// So we now have blending enabled. But how do we use it?
// We need to set up how the current objects are going to be blended.
// I am using the blending function:
// glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
// Which takes the current colour, and blends it with the colours behind it
// according to the Alpha value we set.

// Now to set the Alpha value we need to change our current colour line which
// looks like: glColor3f(1, 0, 0);
// to make it look like:
// glColor4f(1, 0, 0, 0.2);
// Here the fourth value of 0.2 is our opacity level. With 1 being the highest
// (fully opaque), and 0 being the lowest (fully transparent, will not be visible).

// And that is all that there is.

// Just remember that objects that are drawn on the
// screen are drawn in the order in which you choose to draw them. So if you
// draw a square (square1), before another square (square2), then if square1
// is brought infront of square2 while square1 has an alpha value, then
// square1 will not show square2 behind it.

// If you have any queries feel free to email me at swiftless@gmail.com


#include <GL/gl.h>
#include <GL/glut.h>

GLfloat angle = 0.0;

void cube (void) {
	glRotatef(angle, 1.0, 0.0, 0.0);
	glRotatef(angle, 0.0, 1.0, 0.0);
	glRotatef(angle, 0.0, 0.0, 1.0);
	glColor4f(1.0, 0.0, 0.0, 0.2); //set the color and alpha of the cube
	glutSolidCube(2);
	glColor4f(0.0, 1.0, 0.0, 0.5); //set the color and alpha of the cube
	glutSolidCube(1);
}

void display (void) {
	glClearColor (0.0,0.0,0.0,1.0);
    glClear (GL_COLOR_BUFFER_BIT);
	glEnable(GL_BLEND); //enable the blending
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA); //set the blend function
    glLoadIdentity();  
	gluLookAt (0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
	cube();
	glutSwapBuffers();
	angle ++;
}

void reshape (int w, int h) {
	glViewport (0, 0, (GLsizei)w, (GLsizei)h);
	glMatrixMode (GL_PROJECTION);
	glLoadIdentity ();
	gluPerspective (60, (GLfloat)w / (GLfloat)h, 1.0, 100.0);
	glMatrixMode (GL_MODELVIEW);
}

int main (int argc, char **argv) {
    glutInit (&argc, argv);
	glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGBA); //set the alpha buffer
	glutInitWindowSize (500, 500);
	glutInitWindowPosition (100, 100);
    glutCreateWindow ("A basic OpenGL Window");
    glutDisplayFunc (display);
	glutIdleFunc (display);
	glutReshapeFunc (reshape);
    glutMainLoop ();
    return 0;
}

