// To rotate an object the:
// glRotatef (angle of rotation, x axis, y axis, z axis);
// command is called. This will rotate it on the specified axis
// to the value of whatever the rotation is.
// Below the angle is changing on every update of the window.
// And because we have the rotate command called, once for every
// axis, it is rotating on all axis the same.

// Because we have the angle updating in the display function
// we call:
// glutIdleFunc (display);
// in the Main function, underneath the glutDisplayFunc command.

// NOTE: the cube will look like a gian mess, check the smooth
// rotation tutorial on how to fix this.

#include <GL/gl.h>
#include <GL/glut.h>

GLfloat angle = 0.0; //the rotation value

void cube (void) {
	glRotatef(angle, 1.0, 0.0, 0.0); //rotate on the x axis
	glRotatef(angle, 0.0, 1.0, 0.0); //rotate on the y axis
	glRotatef(angle, 0.0, 0.0, 1.0); //rotate on the z axis
	glColor3f(1.0, 0.0, 0.0);
	glutWireCube(2);
}

void display (void) {
	glClearColor (0.0,0.0,0.0,1.0);
    glClear (GL_COLOR_BUFFER_BIT);
    glLoadIdentity();  
	gluLookAt (0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
	cube();
	glutSwapBuffers();
	angle ++; //update the angle of rotation
}

void reshape (int w, int h) {
	glViewport (0, 0, (GLsizei)w, (GLsizei)h);
	glMatrixMode (GL_PROJECTION);
	glLoadIdentity ();
	gluPerspective (60, (GLfloat)w / (GLfloat)h, 1.0, 100.0);
	glMatrixMode (GL_MODELVIEW);
}

int main (int argc, char **argv) {
    glutInit (&argc, argv);
	glutInitDisplayMode (GLUT_DOUBLE);
	glutInitWindowSize (500, 500);
	glutInitWindowPosition (100, 100);
    glutCreateWindow ("A basic OpenGL Window");
    glutDisplayFunc (display);
	glutIdleFunc (display); //change any idle values accordingly
	glutReshapeFunc (reshape);
    glutMainLoop ();
    return 0;
}
