// Scaling means stretching, so when you scale an object,
// you are changing it's width, length and depth.
// Or width, height and depth. However you were taught in school.

// Now in this tutorial we are making 2 cubes, one is scaled to be
// twice as wide, half the height and the same depth, the other is
// normal. To achieve this we add the line:
// glScalef( 2.0, 0.5, 1.0 ); 
// before the object that were are scaling. 
// The 2, means twice or 2 times (X)
// The 0.5 means half or 0.5 times
// The 1 means times by 1, so you get the same value that
// you started off with.

#include <GL/gl.h>
#include <GL/glut.h>

GLfloat angle = 0.0;

void cube (void) {
	//scaled
	glScalef( 2.0, 0.5, 1.0 );  //twice as wide, half the height, same depth
//	glRotatef(angle, 1.0, 0.0, 0.0);
//	glRotatef(angle, 0.0, 1.0, 0.0);
//	glRotatef(angle, 0.0, 0.0, 1.0);
	glColor4f(1.0, 0.0, 0.0, 0.25); //25% visible
	glutWireCube(2);
	//non scaled
//	glRotatef(angle, 1.0, 0.0, 0.0);
//	glRotatef(angle, 0.0, 1.0, 0.0);
//	glRotatef(angle, 0.0, 0.0, 1.0);
	glColor4f(0.0, 1.0, 0.0, 0.25); //25% visible
	glutSolidCube(1);
}

void display (void) {
	glClearColor (0.0,0.0,0.0,1.0);
    glClear (GL_COLOR_BUFFER_BIT);
	glEnable(GL_BLEND); //enable the blending
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA); // set the blending
    glLoadIdentity();  
	gluLookAt (0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
	cube();
	glutSwapBuffers();
	angle ++;
}

void reshape (int w, int h) {
	glViewport (0, 0, (GLsizei)w, (GLsizei)h);
	glMatrixMode (GL_PROJECTION);
	glLoadIdentity ();
	gluPerspective (60, (GLfloat)w / (GLfloat)h, 1.0, 100.0);
	glMatrixMode (GL_MODELVIEW);
}

int main (int argc, char **argv) {
    glutInit (&argc, argv);
	glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGBA); //set up for the alpha channel
	glutInitWindowSize (500, 500);
	glutInitWindowPosition (100, 100);
    glutCreateWindow ("A basic OpenGL Window");
    glutDisplayFunc (display);
	glutIdleFunc (display);
	glutReshapeFunc (reshape);
    glutMainLoop ();
    return 0;
}

