// Here is your first OpenGL tutorial. How to make a Window.
// First off you need to call the OpenGL header files. The basics are
// gl.h and glut.h, with these two your program will run on whatever OS
// it is compiled in as it does not currently rely on Windows.

// So that you know, the gl.h supplies the openGL commands while glut.h
// allows us to call the glut commands. If you are not using glut, then
// do not bother to call this.

// After this next little bit, the rest of the code is explained below in the actual code.

// To reshape a window in GLUT you need one command in the 'main' function
// this is:
// glutInitWindowSize (500, 500);
// this will set it to 500 pixels wide and 500 high.
// The other line you may notice I have added is:
// glutInitWindowPosition (100, 100);
// This sets where the window is located on the screen, in this case
// 100 pixels down and 100 to the right.

#include <GL/gl.h> //include the gl header file
#include <GL/glut.h> //include the glut header file

void display (void) {
	glClearColor (0.0,0.0,0.0,1.0); //clear the color of the window
    glClear (GL_COLOR_BUFFER_BIT); //Clear teh Color Buffer (more buffers later on)
    glLoadIdentity();  //load the Identity Matrix
    gluLookAt (0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0); //set the view
	glFlush(); //flush it all to the screen
}

int main (int argc, char **argv) {
    glutInit (&argc, argv); //initialize the program.
	glutInitDisplayMode (GLUT_SINGLE); //set up a basic display buffer (only singular for now)
	glutInitWindowSize (500, 500); //set whe width and height of the window
	glutInitWindowPosition (100, 100); //set the position of the window
    glutCreateWindow ("A basic OpenGL Window"); //set the caption for the window
    glutDisplayFunc (display); //call the display function to draw our world
    glutMainLoop (); //initialize the OpenGL loop cycle
    return 0;
}

