// Now as the window is reshaped, you may notice in the other programs,
// that it might act a little weird, in this we add the 'reshape'
// function. This sets up our View Port and our Perspective mode with
// its parameters.
// Our glViewport, starts at 0,0 the top left hand corner, and goes
// until it reaches the height and width of our window. So from the top
// left to the bottom right.
// By setting our Matrix Mode to GL_PROJECTION we can play with the 'camera'.
// We are setting up our 'camera' to a Perspective mode, this means that
// things in the distance appear smaller than those closer to the 'camera'.
// Now I will explain the line:
// gluPerspective (60, (GLfloat)w / (GLfloat)h, 1.0, 100.0);
// Our first value here is the angle of sight, so if you could stick your 
// arms out infront of you in a 60 degree angle and erase everything on the
// outside, what is on the inside is what you would see. The next value determines
// the aspect ratio of the field of sight in the x direction, where x is the
// ratio of x(width) / y(height), then comes the value of 1.0, this is the near factor,
// and this is the closest something can get to the 'camera' before dissappearing. Last
// is the value 100, this is the far value and is how far the camera can see, so
// anything further than 100 would not be drawn.

// After this we switch back to our ModelView MatrixMode so we can edit our objects.

#include <GL/gl.h>
#include <GL/glut.h>

void cube (void) {
	glutWireCube(2);
}

void display (void) {
	glClearColor (0.0,0.0,0.0,1.0);
    glClear (GL_COLOR_BUFFER_BIT);
    glLoadIdentity();  
	gluLookAt (0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
	cube();
	glFlush();
}

void reshape (int w, int h) {
//	glViewport (0, 0, (GLsizei)w, (GLsizei)h);
	glMatrixMode (GL_PROJECTION); //set it so we can play with the 'camera'
//	glLoadIdentity (); //replace the current matrix with the Identity Matrix
	gluPerspective (60, (GLfloat)w / (GLfloat)h, 1.0, 100.0); //set the angle of view, the ratio of sight, the near and far factors
	glMatrixMode (GL_MODELVIEW); //switch back the the model editing mode.
}

int main (int argc, char **argv) {
    glutInit (&argc, argv);
	glutInitDisplayMode (GLUT_SINGLE);
	glutInitWindowSize (500, 500); //set the size of the window
	glutInitWindowPosition (100, 100); //set the position of the window
    glutCreateWindow ("A basic OpenGL Window");
    glutDisplayFunc (display);
	glutReshapeFunc (reshape);
    glutMainLoop ();
    return 0;
}
